#ifndef ADC_H
#define ADC_H

// <<< Use Configuration Wizard in Context Menu >>>
// <h> Set ADCCONT 
// <o.3> ADCCKS <0=> 24MHz <1=> 12MHz
// <i> ADC conversion clock select
// <o.4> ADCDS <0=> ADCD2 MSB <1=> ADCD2 LSB
// <o.5..6> ADCSH <0=> 1 clock <1=> 2 clock <2=> 3 clock <3=> 4 clock
// <o.7> ADCPD <0=> Normal <1=> Power Down
// </h>
#define ADCCONT_REGS 0x18

// <h> Set ADCSTR
// <o.6..7> SHCKS <0=> 6MHz <1=> 3MHz <2=> 2.4MHz <3=> 2MHz
// </h>
#define ADCSTR_REGS 0xC0
// <<< end of configuration section >>>

extern xdata	signed int OPA_Offset;
// extern xdata	signed int OPA_Offset_ia;
// extern xdata	signed int OPA_Offset_ib;
extern xdata	signed int OPA_OffsetTemp;
extern xdata	signed int OPA_Offset_C;
extern xdata	unsigned int OffsetCount;

extern void Adc_Init (void);
extern unsigned int Adc_Channel (unsigned char Channel);
extern void Correction_Current_AD_offset(void);
#endif